#include <bits/stdc++.h>
using namespace std;

typedef long long ll;

double closest_dist(double qx, double qy, double hy, double px1, double py1, double px2, double py2) {
    double dx = px2 - px1;
    double dy = py2 - py1;
    if (fabs(dx) < 1e-9 && fabs(dy) < 1e-9) {
        if (py1 >= hy) return sqrt((px1 - qx) * (px1 - qx) + (py1 - qy) * (py1 - qy));
        return 1e100;
    }
    double t_hy;
    if (fabs(dy) < 1e-9) {
        if (py1 >= hy) {
            double len2 = dx * dx + dy * dy;
            double t = ((qx - px1) * dx + (qy - py1) * dy) / len2;
            t = max(0.0, min(1.0, t));
            double projx = px1 + t * dx;
            double projy = py1 + t * dy;
            return sqrt((projx - qx) * (projx - qx) + (projy - qy) * (projy - qy));
        } else {
            return 1e100;
        }
    }
    t_hy = (hy - py1) / dy;
    double t_min, t_max;
    if (dy > 0) {
        if (hy <= py1) t_min = 0, t_max = 1;
        else if (hy > py2) return 1e100;
        else t_min = t_hy, t_max = 1;
    } else {
        if (hy <= py2) t_min = 0, t_max = 1;
        else if (hy > py1) return 1e100;
        else t_min = 0, t_max = t_hy;
    }
    if (t_min > t_max) return 1e100;
    double p1x = px1 + t_min * dx;
    double p1y = py1 + t_min * dy;
    double p2x = px1 + t_max * dx;
    double p2y = py1 + t_max * dy;
    double dx2 = p2x - p1x;
    double dy2 = p2y - p1y;
    double len2 = dx2 * dx2 + dy2 * dy2;
    if (len2 < 1e-9) return sqrt((p1x - qx) * (p1x - qx) + (p1y - qy) * (p1y - qy));
    double t = ((qx - p1x) * dx2 + (qy - p1y) * dy2) / len2;
    t = max(0.0, min(1.0, t));
    double projx = p1x + t * dx2;
    double projy = p1y + t * dy2;
    return sqrt((projx - qx) * (projx - qx) + (projy - qy) * (projy - qy));
}

int main() {
    int n;
    scanf("%d", &n);
    vector<ll> x(n), h(n);
    for (int i = 0; i < n; i++) scanf("%lld", &x[i]);
    for (int i = 0; i < n; i++) scanf("%lld", &h[i]);

    vector<pair<ll, ll>> v(n);
    for (int i = 0; i < n; i++) v[i] = {x[i], h[i]};
    sort(v.begin(), v.end());

    for (int i = 0; i < n; i++) {
        double min_d = 1e100;
        double qx = v[i].first, qy = v[i].second;

        
        for (int j = i - 1; j <= i + 1; j++) {
            if (j < 0 || j >= n) continue;

            double px = v[j].first, py = v[j].second;
            if (py >= qy) {
                double d = sqrt((px - qx) * (px - qx) + (py - qy) * (py - qy));
                min_d = min(min_d, d);
            }

            if (j != i) {
                ll x1 = v[min(i, j)].first, y1 = v[min(i, j)].second;
                ll x2 = v[max(i, j)].first, y2 = v[max(i, j)].second;
                ll a = (y1 - y2 + x2 - x1) / 2;
                ll b = y1 - (a - x1);
                double d1 = closest_dist(qx, qy, qy, x1, y1, a, b);
                double d2 = closest_dist(qx, qy, qy, a, b, x2, y2);
                min_d = min({min_d, d1, d2});
            }
        }

        if (min_d > 1e99) printf("-1\n");
        else printf("%.0f\n", min_d);
    }

    return 0;
}